import librosa
import soundfile as sf
import numpy as np

# y is a numpy array of the wav file, sr = sample rate
y, sr = librosa.load('a2002011001-e02.wav', sr=48000)


# if we want to shift pitch
# y_shifted = librosa.effects.pitch_shift(y, sr, n_steps=4) # shifted by 4 half steps

# checkout for sampling rate
# https://librosa.github.io/librosa/generated/librosa.core.samples_to_time.html#librosa.core.samples_to_time
# https://librosa.github.io/librosa/generated/librosa.core.time_to_samples.html


y_scaled = y / np.max(np.abs(y)) * 0.4

sf.write("out_int16.wav", y_scaled, sr, 'PCM_16')
